#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Apr 25 11:41:39 2020

@author: yann
"""
#%%
import numpy as np
import matplotlib.pyplot as plt
# valeurs experimentales

x=np.array([0.41,0.91,1.39,1.86,2.33,2.81,3.33,3.79,4.31,4.83,5.36,5.86,6.34])
y=np.array([0.52,1.01,1.42,1.77,2.02,2.16,2.19,2.13,1.96,1.71,1.38,0.97,0.50])
t=0.1*np.arange(len(x))

vxl=[]
m=np.arange(len(t)-2)
for i in m :
    vx=(x[i+2]-x[i])/(t[i+2]-t[i])
    vxl.append(vx)
vxll=np.array(vxl)
vyl=[]
m=np.arange(len(t)-2)
for i in m :
    vy=(y[i+2]-y[i])/(t[i+2]-t[i])
    vyl.append(vy)
vyll=np.array(vyl)
print(len(vxll))

#%%
m=0.60
g=9.8    
v=(vxll**2+vyll**2)**(1/2)
ec=0.5*m*v**2
y2=y[1:-1]
ep=m*g*y2
em=ec+ep
t2=t[1:-1]

plt.plot(t2,ec,'bo-',label='Ec')
plt.plot(t2,ep,'go-',label='Ep')
plt.plot(t2,em,'ro-',label='Em')
plt.xlabel("temps")
plt.ylabel("énergie")
plt.title("évolution des énergies au cours du mouvement")
plt.legend()
plt.grid()
plt.show()


#%%
mod=np.polyfit(t2,em,0)
moda=0*t2+mod[0]

plt.plot(t2,ec,'bo-',label='Ec')
plt.plot(t2,ep,'go-',label='Ep')
plt.plot(t2,em,'ro-',label='Em')
plt.plot(t2,moda,'k-',label='Modèle')
plt.xlabel("temps")
plt.ylabel("énergie")
plt.title("évolution des énergies au cours du mouvement")
plt.legend()
plt.grid()
plt.show()